﻿
////////////////////////////////////////////////////////////////////////////////////////////////////// Auto Render //////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Auto Render v2.0
// by Simon Bjork
// January 2012
// bjork.simon@gmail.com

////////////////////////////////////////////////////////////////////////////////////////////////////// User variables //////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Edit the user varibles to work in your pipeline. For example, if you wanted your renders to go to a "Exports" folder instead, you would edit UV2 to "Exports" instead of "renders".

var UV1 = "projectfiles"; //  The name of the last folder before the render folder in the project file path. For example, if the file path is "shot01/projectfiles/ae/shot01_v001.aep" the renders will be sent to the folder before projectfiles, which would be "shot01/renders".
var UV2 = "renders"; // The name of the render folder.
var UV3 = "prerenders"; // The name of the pre render folder.
var UV4 = "proxys"; // The name of the proxy render folder.
var UV5 = "_" // The character before #### when rendering image sequences. For example, shot01_v001_####.exr.
var UV6 = "####"; // The number of digits when rendering image sequences.
var UV7 = "yes"; // Use a subfolder in the render directory. For example, renders/ae/shot01_v001 instead of renders/shot_01_v001.
var UV8 = "yes"; // Use a subfolder in the prerender directory. 
var UV9 = "yes" // Use a subfolder in the proxy directory. 
var UV10 = "ae"; // The name of the subfolder in render directory if UV7 is set to "yes".
var UV11 = "ae"; // The name of the subfolder in prerender directory if UV8 is set to "yes".
var UV12 = "aey"; // The name of the subfolder in the proxy directory if UV9 is set to "yes".
var UV13 = "yes"; // Use file format subfolder in the render folder. For example, renders/ae/shot_01_v001/dpx/shot01_v001.####.dpx
var UV14 = "no"; // Use file format subfolder in the prerender folder.
var UV15 = "yes"; // Use file format subfolder in the proxyrender folder.
var UV16 = "vXXX"; // Naming convention. Recommended  use is vXX or vXXX.
var UV17= "_"; // The character before user initials. For example, shot01_v001_sb.####.exr

////////////////////////////////////////////////////////////////////////////////////////////////////// User variables //////////////////////////////////////////////////////////////////////////////////////.///////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////// Rush variables //////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Rush® Network Render (http://seriss.com/rush) settings.

var RV1 = "/Volumes/misc/vfx_tools/rush_scripts/submit-afterfx.pl"; // The path to the Rush submit script.
var RV2 = "yes"; // Set the batch clip to true.
var RV3 = "4"; // Number of frames to batch.
var RV4 = "CS5.5"; // default AE version.
var RV5 = "atlas";  // Default cpu specification.

////////////////////////////////////////////////////////////////////////////////////////////////////// Rush variables //////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////// Default settings //////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Default settings when the script is launced. Make sure you use true or false only, otherwise the script will crash.

var startFrame = ""; // First frame in text box.
var endFrame = ""; // Last frame in text box.

var useWorkArea = true // Use work area checkbox.
var renderSetting = "Best Settings"; // Name of render setting.
var outputSetting = "DPX_fullRange_RGB"; // Name of output setting.

// Set only one of the following three naming options to true.
var automaticRender = true; // Automatic name.
var customRender = false; // Custom name.
var layerNameRender = false; // Layer name.

// Set only one of the following three render types to true.
var normalRender = true; // Normal render.
var preRender = false; // Pre render.
var proxyRender = false; // Proxy render. 

var versionUp = true; // Version up checkbox.
var queOnly = true; // Que only checkbox.
var useInitials = false; // Add user initials to the render name.
var defaultInitials = "" // Default user initials.
var rushNetworkRender = false; // Rush Network Render checkbox.

var customName = ""; // Custom name text box.
var customLayerName = ""; // Custom layer name text box.


////////////////////////////////////////////////////////////////////////////////////////////////////// Default settings //////////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////// Build UI function start ////////////////////////////////////

var myPalette = buildUI(this);

    if(myPalette != null && myPalette instanceof Window) {
        myPalette.show();
            }

function buildUI (thisObject) {
    
    if(thisObject instanceof Panel) {
        var myPalette = thisObject;
        }else{
        var myPalette = new Window ("palette", "Auto Render", undefined, {resizeable:true});
        }

    if(myPalette != null) {
    
        var res =
        "Group { \
         orientation: 'row', \
         alignment: ['fill', 'fill'], \
         alignChildren: ['left', 'top'], \
         left: Group { \
            orientation: 'column', \
            one: Group { \
               orientation: 'row', \
                alignment: ['left', 'top'], \
                searchTxt: StaticText {text:'Frame range:'}, \
                firstFrame: EditText {size: ['100', '25']}, \
                lastFrame: EditText {size: ['100', '25']}, \
                workArea: Checkbox {text: 'Use work area'}, \
                } \
            two: Group { \
               orientation: 'row', \
            alignment: ['left', 'top'], \
                renderSetting: DropDownList {size: ['100', '25']}, \
                outputSetting: DropDownList {size: ['100', '25']}, \
                refreshTemplates:  Button {text: 'Refresh templates', size: ['110', '25']}, \
                } \
            three: Group { \
               orientation: 'row', \
                alignment: ['left', 'top'], \
                automaticRender: RadioButton {text: 'Automatic file name'},\
                customRender: RadioButton {text: 'Custom file name'},\
                layerNameRender: RadioButton {text: 'Layer file name'},\
                } \
            four: Group { \
               orientation: 'row', \
               alignment: ['left', 'top'], \
                normalRender: RadioButton {text: 'Normal render'},\
                preRender: RadioButton {text: 'Pre render'},\
                proxyRender: RadioButton {text: 'Proxy render'},\
                } \
            five: Group { \
               orientation: 'row', \
               alignment: ['left', 'top'], \
                versionUp: Checkbox {text: 'Version up'}, \
                que: Checkbox {text: 'Que only'}, \
                useInitials: Checkbox {text: 'Use initials'},\
                initials: EditText {size: ['100', '25']}, \
                } \
            six: Group { \
               orientation: 'row', \
               alignment: ['left', 'top'], \
                rushNetworkRender: Checkbox {text: 'Rush® Network Render'}, \
                } \
            seven: Group { \
               orientation: 'row', \
               alignment: ['left', 'top'], \
                customNameTxt: StaticText {text:'Custom name:'}, \
                customName: EditText {size: ['100', '25']}, \
                } \
            eight: Group { \
               orientation: 'row', \
               alignment: ['left', 'top'], \
                layerNameTxt: StaticText {text:'Layer name:'}, \
                layerNames: DropDownList {size: ['100', '25']}, \
                refreshLayers:  Button {text: 'Refresh layers', size: ['90', '25']}, \
                renderLayerNameTxt: StaticText {text:'Render name:'}, \
                customLayerName: EditText {size: ['100', '25']}, \
                } \
            nine: Group { \
                orientation: 'row', \
                alignment: ['left', 'top'], \
                help:  Button {text: 'Help', size: ['40', '25']}, \
                } \
         } \
         right: Group { \
            orientation: 'row', \
            alignment: ['right', 'top'], \
            renderButton: Button {text: 'Render', size: ['100', '50']}, \
         } \
      }";

myPalette.grp = myPalette.add(res);
myPalette.layout.layout(true);
myPalette.layout.resize()
myPalette.resizing = myPalette.onResize = function () {this.layout.resize()};

// Add render and output templates to the UI by adding a composition, taking values and then delete the composition.
var tempComp = app.project.items.addComp("tempAutoRender",1920,1080,1,1,25);
var myTempRQItem = app.project.renderQueue.items.add(tempComp) ;

// Add render settings
    for(i=0; i<app.project.renderQueue.item(1).templates.length; i++) {
        if (app.project.renderQueue.item(1).templates[i].indexOf("_HIDDEN") != 0){ //Don't add hidden templates.
            myPalette.grp.left.two.renderSetting.add('item',app.project.renderQueue.item(1).templates[i]);
        }
    }//for(i=0; i<app.project.renderQueue.item(1).templates.length; i++) {
  
// Add output settings
    for(i=0; i<app.project.renderQueue.item(1).outputModules[1].templates.length; i++) {
        if (app.project.renderQueue.item(1).outputModules[1].templates[i].indexOf("_HIDDEN") != 0){ //Don't add hidden templates.
         myPalette.grp.left.two.outputSetting.add('item',app.project.renderQueue.item(1).outputModules[1].templates[i]);
         }
    }//for(i=0; i<app.project.renderQueue.item(1).outputModules[1].templates.length; i++) {

tempComp.remove();

// Add compositions to the layer names drop-down list.
for(i=1; i<=app.project.numItems; i++){
    if(app.project.item(i) instanceof CompItem){
        myPalette.grp.left.eight.layerNames.add('item',app.project.item(i).name);
        }
    }

// Add footage items to the layer names drop-down list.
var itemIs = false;

    for(i=1; i<=app.project.numItems; i++){
        if(app.project.item(i) instanceof FootageItem && app.project.item(i).parentFolder.name != "Solids"){
            var footageItem = app.project.item(i).name;
            for(j=0; j<myPalette.grp.left.eight.layerNames.items.length; j++){
                if(myPalette.grp.left.eight.layerNames.items[j].toString() == footageItem){
                var itemIs = true;            
                } // if(myPalette.grp.left.eight.layerNames.items[j].toString() == footageItem;            
                } // for(j=0; j<myPalette.grp.left.eight.layerNames.items.length; j++){
            if(itemIs == false){
                myPalette.grp.left.eight.layerNames.add('item',footageItem);
            } //  if(itemIs == false){                
        } // if(app.project.item(i) instanceof FootageItem && app.project.item(i).parentFolder.name != "Solids"){
    } //for(i=1; i<=app.project.numItems; i++){

// Check for default values for render settings.
    for(var i = 0; i< myPalette.grp.left.two.renderSetting.items.length; i++){
        if(myPalette.grp.left.two.renderSetting.items[i].toString() == renderSetting){
        var defaultRender = i;
        break;
            }else{
            var defaultRender = 0;
            }
    }

// Check for default values for output settings.
    for(var i = 0; i< myPalette.grp.left.two.outputSetting.items.length; i++){
        if(myPalette.grp.left.two.outputSetting.items[i].toString() == outputSetting){
        var defaultOutput = i;
        break;
            }else{
            var defaultOutput = 0;
            }
    }

// Set default settings. 
myPalette.grp.left.one.firstFrame.text = startFrame;
myPalette.grp.left.one.lastFrame.text = endFrame;
myPalette.grp.left.one.workArea.value = useWorkArea;
myPalette.grp.left.two.renderSetting.selection = myPalette.grp.left.two.renderSetting.items[defaultRender];
myPalette.grp.left.two.outputSetting.selection = myPalette.grp.left.two.outputSetting.items[defaultOutput];
myPalette.grp.left.three.automaticRender.value = automaticRender;
myPalette.grp.left.three.customRender.value = customRender;
myPalette.grp.left.three.layerNameRender.value = layerNameRender;
myPalette.grp.left.four.normalRender.value = normalRender;
myPalette.grp.left.four.preRender.value = preRender;
myPalette.grp.left.four.proxyRender.value = proxyRender;
myPalette.grp.left.five.versionUp.value = versionUp;
myPalette.grp.left.five.que.value = queOnly;
myPalette.grp.left.five.useInitials.value = useInitials;
myPalette.grp.left.six.rushNetworkRender.value = rushNetworkRender;
myPalette.grp.left.seven.customName.text = customName;
myPalette.grp.left.eight.customLayerName.text = customLayerName;

if(useWorkArea == true){
    myPalette.grp.left.one.firstFrame.enabled = false;
    myPalette.grp.left.one.lastFrame.enabled = false;
        }else{
            myPalette.grp.left.one.firstFrame.enabled = true;
            myPalette.grp.left.one.lastFrame.enabled = true;
            }

if(automaticRender == true){
    myPalette.grp.left.seven.enabled = false;
    myPalette.grp.left.eight.enabled = false;
    }

if(customRender == true){
    myPalette.grp.left.seven.enabled = true;
    myPalette.grp.left.eight.enabled = false;
    }

if(layerNameRender == true){
    myPalette.grp.left.seven.enabled = false;
    myPalette.grp.left.eight.enabled = true;  
    }

if(useInitials == true){
    myPalette.grp.left.five.initials.enabled = true;
    myPalette.grp.left.five.initials.text = defaultInitials;
        }else{
            myPalette.grp.left.five.initials.enabled = false;
            myPalette.grp.left.five.initials.text = "";
            }

// Run functions
myPalette.grp.left.one.workArea.onClick = function () {
    frameRangeStatus (myPalette);
    }

myPalette.grp.right.renderButton.onClick = function () {
    renderFunction (myPalette);
    }

myPalette.grp.left.nine.help.onClick = function () {
    help (myPalette);
    }

myPalette.grp.left.two.refreshTemplates.onClick = function () {
    refreshTemplates (myPalette);
    }

myPalette.grp.left.eight.refreshLayers.onClick = function () {
    refreshLayers (myPalette);
    }

myPalette.grp.left.eight.layerNames.onChange = function () {
    customLayerNameText (myPalette);
    }

myPalette.grp.left.three.automaticRender.onClick = function () {
    automaticDisableGroups (myPalette);
    }


myPalette.grp.left.three.customRender.onClick = function () {
    customDisableGroups (myPalette);
    }

myPalette.grp.left.three.layerNameRender.onClick = function () {
    layerNameDisableGroups (myPalette);
    }

myPalette.grp.left.five.useInitials.onClick = function () {
    toggleInitials (myPalette);
    }



}//if(myPalette != null) {

// Deselect all compositions in the project window. To prevent errors in frame range.
for(var i = 1; i<=app.project.numItems; i++){
    if(app.project.item(i) instanceof CompItem){
    app.project.item(i).selected = false;
    }
}

return myPalette;

} //buildUI

//////////////////////////////////// Build UI function end ////////////////////////////////////

//////////////////////////////////// Render function start ////////////////////////////////////

function renderFunction (palObject) {

// Main render function.

// Check to see if scripts are allowed to write files.
var securitySetting = app.preferences.getPrefAsLong("Main Pref Section", "Pref_SCRIPTING_FILE_NETWORK_SECURITY");
    if ( securitySetting != 1) {
        alert ("Please enable 'Allow script to write files and to newtwork' in the preferences.");
        return;
    }

// Check to see if the project file is saved.
    if (!app.project.file) {
        alert("Please save the project before running the script. Use " + UV16 + " naming convention.");
        app.project.saveWithDialog();
        return;
    }

// Project file path.  
var projectPath = app.project.file.fsName.toString();

// The name of the AE project file and remove .aep extension.
var aePF = app.project.file.name.replace(/%20/gi," ");
var aePFnoExt = aePF.substring(0,aePF.length-4);

// Check to see if the file path is correct.
    if(!projectPath.match((UV1))) {
        alert("The project file path does not contain " + UV1 + " . This is a variable that needs to be set depending on the folder structure of your system. Open the Auto Render script and edit the first user variable, or move your project file to the correct path.")
        return;
    }

// Make sure the naming convention is possible.
    if(UV16.length == 2 && aePFnoExt.slice(-1) == 9){
        if(myPalette.grp.left.five.versionUp.value == true){
        alert("Current naming convention is " + UV16 + " Saving a new version will break this. Open the script and change the naming convention to for example vXX.");
        return;
        }
    }

// Check that a "v" is used in the name.
var checkV = UV16.charAt(0);

    if(checkV != "v"){
        alert("Current naming convention is " + UV16 + ". You must use a v in the naming convention, for example vXXX");
        return;
        }

// Check to see what naming convention to use.
var lookV = 5 + (UV16.length - 1);
var lookUnderscore = 6 + (UV16.length - 1);

var theV = aePF.charAt(aePF.length - lookV);
var theUnderscore = aePF.charAt(aePF.length - lookUnderscore);

var numbersInName = UV16.length - 1;

var numZeros = "0";
var zero = "0";

    for(var j = 1; j<numbersInName - 1;j++){
    var numZeros = numZeros + zero;
    }

    if(numbersInName == 1){
        var versionNumber = "1";
            }else{
            var versionNumber = numZeros + "1"
        }

// Check that the naming is correct.
    if(theV != "v" && theUnderscore != "_"){
        var nameConvention = confirm("Error in project file name. You need to use _" + UV16 + " naming conventions. Do you want the script to automatically save the project file with the new name: " +  aePFnoExt + "_v" + versionNumber + ".aep");
        if(nameConvention == true) {
        var saveNewPath = projectPath.substring(0,projectPath.length-4);
        var newSaveName = saveNewPath + "_v" + versionNumber + ".aep";
        var saveNameConvention = new File(newSaveName);
        app.project.save(saveNameConvention);
            }else{
                return;
        }//if(nameConvention == true) {
    }// if(aePF.charAt(aePF.length - 9) != "_" && aePF.charAt(aePF.length - 8) != "v") {


// Check for initials.
    if(palObject.grp.left.five.useInitials.value == true && palObject.grp.left.five.initials.text == ""){
        alert("Use initials is selected. Please enter your initials.");
        return;
    }

// Check for a custom name.
    if(palObject.grp.left.three.customRender.value == true && palObject.grp.left.seven.customName.text == ""){
        alert("Please enter a custom file name.");
        return;
    }

// Check for a layer name.
    if(palObject.grp.left.three.layerNameRender.value == true && palObject.grp.left.eight.customLayerName.text == ""){
        alert("Please enter a file name.");
        return;
    }

// Check for Rush submit script.
    if(palObject.grp.left.six.rushNetworkRender.value == true){
    var submitScript = File(RV1);
        if (!submitScript.exists){
        alert("Can't find the Rush submit script. Did you enter the correct path? Current path: " + RV1 + ".")
        return;
        }
    }

// Check to see if a composition is selected.
    if(app.project.selection == 0) {
        alert("Please select a composition.");
        return;
    }

// Check to see that only one composition is selected.
if(app.project.selection.length > 1){
    alert("Select only one composition.");
    return;
    }

// Make sure that the user has entered a frame range.
    if (palObject.grp.left.one.workArea.value == false) { 
        if(palObject.grp.left.one.firstFrame.text == "" || palObject.grp.left.one.lastFrame.text == "" ) {
            alert("Please set a frame range or use work area duration.");
            return;
        }
    }//if (workAreaCheckbox == false) { 

// Check to see if render settings and output settings are chosen.
    if(palObject.grp.left.two.renderSetting.selection == null) {
        alert("Please select a render setting.");
        return;
    }

    if(palObject.grp.left.two.outputSetting.selection == null) {
            alert("Please select a output setting.");
            return;
    }

//~ // If the render is to be rendered on the network, check if there are other items in the RQ.
//~     if(palObject.grp.left.six.rushNetworkRender.value == true && app.project.renderQueue.numItems > 0) {
//~         var removeFromRQ = confirm("There can't be several items in the render que when you send the project to Rush Network Render. Do you want to remove them automatically?");
//~         if(removeFromRQ == true) {
//~             for(var i = app.project.renderQueue.numItems; i>=1; i--) {
//~             app.project.renderQueue.item(i).remove();
//~             }//for(var i = app.project.numItems; i>=1; i--) {
//~                 }else{
//~                     return;
//~                     }//if(removeFromRQ == true) {
//~     }//if(palObject.grp.rushNetworkRender.value == true && app.project.renderQueue.numItems > 0) {

// Check if several active items are in the RQ.
    if(palObject.grp.left.five.que.value != true && app.project.renderQueue.numItems != 0){
            for(var i=1;i<=app.project.renderQueue.numItems; i++){
                var rqStatus = app.project.renderQueue.item(i).status;
                if(rqStatus == "2615"){
                    var rqActive = "yes";
                    break;
                    }else{
                        var rqActive = "no"
                        } // if(rqStatus == "2615"){
                    } // for(var i =  1;i<=exceptLast; i++){
            if(rqActive == "yes"){
                var renderCount = confirm("There are other active items in the render queue that will render as well.");
                if(renderCount == false){
                    return;
                    } // if(renderCount == false){
                } // if(rqActive == "yes"){
            } // if(palObject.grp.left.five.que.value != true && app.project.renderQueue.numItems != 0){

// Selected composition. Uses a work around to find the selected composition as app.project.activeItem was causing problems.
    for(var i = 1; i<=app.project.numItems; i++){
        if(app.project.item(i).selected == true){
            if(app.project.item(i) instanceof CompItem){
            var myComp = app.project.item(i);
            }else{
                alert("Plese select a composition");
                break;
                }
            }
        }

// Composition start time in seconds.
var compStart = myComp.displayStartTime;

// Add composition to the RQ.
app.project.renderQueue.items.add(myComp); 

var lastInRQ = app.project.renderQueue.numItems;

// Set render and output templates.
app.project.renderQueue.item(lastInRQ).applyTemplate(palObject.grp.left.two.renderSetting.selection);
app.project.renderQueue.item(lastInRQ).outputModules[1].applyTemplate(palObject.grp.left.two.outputSetting.selection);

// Set the in and out-point of the render.
    if(palObject.grp.left.one.workArea.value == true){
        // Set the in/out-point according to the work area.
        app.beginSuppressDialogs();
        app.project.renderQueue.item(lastInRQ).timeSpanStart = myComp.workAreaStart;
        app.project.renderQueue.item(lastInRQ).timeSpanDuration = myComp.workAreaDuration;
        app.endSuppressDialogs(false);        
        }else{ // if(palObject.grp.left.one.workArea.value == true){
        // Set in and out-point according to the frame range boxes.
        var frame = palObject.grp.left.one.firstFrame.text;
        var fis = myComp.frameDuration*frame; // frame in seconds.
        var lframe = palObject.grp.left.one.lastFrame.text;
        var lfis = myComp.frameDuration*lframe; // last frame in seconds.
        var aeVersion = parseFloat(app.version);
        // In and out-point for CS5.5 and later.
            if(aeVersion > 10) {
                var startSec = (fis - 0.005) - compStart; // The -0.005 is a rounding error. See http://www.aenhancers.com/viewtopic.php?f=8&t=334&hilit=workAreaDuration.
                var lastSec = lfis - compStart;
                    if(app.project.framesCountType == "2413"){ // If frame count starts at 1.
                        startSec = startSec - 0.005;
                        }else{ // if(app.project.framesCountType == "2413"){ // If frame count starts at 1.
                        startSec = startSec + myComp.frameDuration - 0.005;
                        }
            }else{// if(aeVersion > 10) {
            // In and out-point for CS5 and earlier.
            var startSec = (fis - 0.005) - compStart;
            startSec = startSec - (app.project.displayStartFrame * myComp.frameDuration) + myComp.frameDuration;
            }
        app.beginSuppressDialogs();
        app.project.renderQueue.item(lastInRQ).timeSpanStart = startSec;
        app.project.renderQueue.item(lastInRQ).timeSpanDuration = (lfis - fis) + myComp.frameDuration/1;
        app.endSuppressDialogs(false);
        } // if(palObject.grp.left.one.workArea.value == true){

// Find the path for the render folder.
var projectPathParent = projectPath.substring(0, projectPath.lastIndexOf(UV1));

// Check so that the output path is not saying "Not specified" and make sure it delivers a file name.
    if(app.project.renderQueue.items[lastInRQ].outputModules[1].file == null) {
        var newFileTemp = new File(projectPathParent);
        app.project.renderQueue.item(lastInRQ).outputModules[1].file = newFileTemp;
        }

// Check for the file extension of the chosen output module.
var newFileString = app.project.renderQueue.items[lastInRQ].outputModules[1].file.toString();
var dot = newFileString.lastIndexOf('.');
var formatExtension = newFileString.substring(dot + 1);

var nameOfProjectFile = app.project.file.name.substring(0,app.project.file.name.length-4);

// Render type:
var typeAutomatic = palObject.grp.left.four.normalRender.value;
var typePre = palObject.grp.left.four.preRender.value;
var typeProxy = palObject.grp.left.four.proxyRender.value;

    if(typeAutomatic == true){
        var renderType = UV2;
    }

    if(typePre == true){
        var renderType = UV3;
    }

    if(typeProxy == true){
        var renderType = UV4;
    }

// Naming type.
var aRender = palObject.grp.left.three.automaticRender.value;
var prRender = palObject.grp.left.three.customRender.value;
var proRender = palObject.grp.left.three.layerNameRender.value;

    if(aRender == true){
    var myName =  nameOfProjectFile;
    } else if (prRender == true){
    var myName = palObject.grp.left.seven.customName.text;
    } else if(proRender == true){
    var myName = palObject.grp.left.eight.customLayerName.text;
    }

// Create render path for normal renders.
    if(typeAutomatic == true){
        if(UV7 == "yes"){
        var renderPath = projectPathParent + renderType +  "/" + UV10 + "/" + myName;
            }else{
            var renderPath = projectPathParent + renderType +  "/" + myName;
            }
         } // if(aRender == true){

// Create render path for pre renders.
     if(typePre == true){
        if(UV8 == "yes"){
        var renderPath = projectPathParent + renderType +  "/" + UV11 + "/" + myName;
            }else{
            var renderPath = projectPathParent + renderType +  "/" + myName;
            }
         } // if(prRender == true){
 
 // Create render path for proxy renders.
      if(typeProxy == true){
        if(UV9 == "yes"){
        var renderPath = projectPathParent + renderType +  "/" + UV12 + "/" + myName;
            }else{
            var renderPath = projectPathParent + renderType +  "/" + myName;
            }
         } // if(proRender == true){
     
// Add initials to the folder name.
    if(palObject.grp.left.five.useInitials.value == true){
        renderPath = renderPath + UV17 + palObject.grp.left.five.initials.text;
        }
 
// Add file-format subfolders. 
 if(typeAutomatic == true && UV13 == "yes"){
    var renderPath = renderPath + "/" + formatExtension;
     } // if(UV13 == "yes"){
 
  if(typePre == true && UV14 == "yes"){
    var renderPath = renderPath + "/" + formatExtension;
     } // if(UV14 == "yes"){
 
  if(typeProxy == true && UV15 == "yes"){
    var renderPath = renderPath + "/" + formatExtension;
     } // if(UV15 == "yes"){ 
 
// Create render folder.
Folder(renderPath).create();

// Create the new file name.
var newFilePath = renderPath + "/" + myName;

// Add intials to the file name.
    if(palObject.grp.left.five.useInitials.value == true){
       newFilePath = newFilePath + UV17 + palObject.grp.left.five.initials.text + "." + formatExtension;
        }

// Add information if it is a image sequence.
    if(formatExtension == "exr" || formatExtension == "dpx" || formatExtension == "cin" || formatExtension == "tiff" || formatExtension == "tif" || formatExtension == "iff" || formatExtension == "jpg" || formatExtension == "jpeg" || formatExtension == "png" || formatExtension == "tga" || formatExtension == "sgi" || formatExtension == "psd" || formatExtension == "hdr") {
    newFilePath= newFilePath + UV5 + "[" + UV6 + "]." + formatExtension;
    }

// Set new render locations.
var newFile = new File(newFilePath);
app.project.renderQueue.item(lastInRQ).outputModules[1].file = newFile;

var currFolder = Folder (renderPath);
var lookFiles =currFolder.getFiles();

    if(lookFiles[0] != undefined) {
        var overWrite = confirm ("Files already exsist in this folder. Press cancel and save a new version of your script, or press ok to render anyway.")
        if(overWrite != true) {
            myRQItem.remove();
            return;
        }//if(overWrite != true) {
    }//if(my[0] != undefined) {

// If the Rush checkbox is checked, run this function.
    if(palObject.grp.left.six.rushNetworkRender.value == true) {
        rushRender (palObject);
    }

// Save project file.    
app.project.save();

// Make sure a certain number can't be used.
var noNumber = false;

if(palObject.grp.left.five.versionUp.value == true) {
    if(aePFnoExt.slice(-2) == "12"){
        var noNumber = true;
        var noNumberName = projectPath.substring(0,projectPath.length-6);
        var noNumberSavePath = noNumberName + "14.aep";
        var noNumberSave = new File(noNumberSavePath);
        app.project.save(noNumberSave);         
        }
    }

// Deselect all compositions in the project window. To prevent errors in frame range.
for(var i = 1; i<=app.project.numItems; i++){
    if(app.project.item(i) instanceof CompItem){
    app.project.item(i).selected = false;
    }
}

// Save a new version of the project file.
if(palObject.grp.left.five.versionUp.value == true && noNumber == false) {
app.executeCommand(app.findMenuCommandId("Increment and Save"));
}

// Start the render.
    if(palObject.grp.left.five.que.value != true && palObject.grp.left.six.rushNetworkRender.value != true ) {
        app.project.renderQueue.render();
    }

}//function renderFunction (palObject) {

//////////////////////////////////// Render function end ////////////////////////////////////

//////////////////////////////////// Refresh templates start ////////////////////////////////////

function refreshTemplates (palObject) {

// Function is used when the "Refresh templates" button is clicked.

// Current render settings.
var currRenderSetting = palObject.grp.left.two.renderSetting.selection.toString()
var currOutputSetting = palObject.grp.left.two.outputSetting.selection.toString();

// Render templates.
var myRQ = app.project.renderQueue;
var tempComp = app.project.items.addComp("tempAutoRender",1920,1080,1,1,25);
var myTempRQItem = myRQ.items.add(tempComp);
var rTemplates = myRQ.item(1).templates;

// Empty the current drop-down list.
myPalette.grp.left.two.renderSetting.removeAll();

// Add items to drop-down list.
    for(var i = 0; i<rTemplates.length;i++){
        if(rTemplates[i].indexOf("_HIDDEN") != 0){
            myPalette.grp.left.two.renderSetting.add('item',rTemplates[i]);
        }//if(rTemplates[i].indexOf("_HIDDEN") != 0)  
    }//if(templateExists == false){

// Output templates.
var oTemplates = myRQ.item(1).outputModules[1].templates;

// Empty the current drop-down list.
myPalette.grp.left.two.outputSetting.removeAll();

// Add items to drop-down list.
    for(var i = 0; i<oTemplates.length; i++){
        if(oTemplates[i].indexOf("_HIDDEN") != 0){
        myPalette.grp.left.two.outputSetting.add('item',oTemplates[i]);
        }
    }


// Set old values for render and output settings.
    for(var i = 0; i< myPalette.grp.left.two.renderSetting.items.length; i++){
        if(myPalette.grp.left.two.renderSetting.items[i].toString() == currRenderSetting){
        var oldRenderSetting = i;
        break;
            }else{
            var oldRenderSetting = 0;
            }
    }

    for(var i = 0; i< myPalette.grp.left.two.outputSetting.items.length; i++){
        if(myPalette.grp.left.two.outputSetting.items[i].toString() == currOutputSetting){
        var oldOutputSetting = i;
        break
            }else{
            var oldOutputSetting = 0;
            }
    }

myPalette.grp.left.two.renderSetting.selection = myPalette.grp.left.two.renderSetting.items[oldRenderSetting];
myPalette.grp.left.two.outputSetting.selection = myPalette.grp.left.two.outputSetting.items[oldOutputSetting];


// Remove temp composition.
tempComp.remove();

}//function networkRendering (palObject) {

//////////////////////////////////// Refresh templates end ////////////////////////////////////

//////////////////////////////////// Refresh layers start ////////////////////////////////////

function refreshLayers(palObject) {

// Function is used when the Refresh layers button is clicked.

// Empty the current drop-down list.
myPalette.grp.left.eight.layerNames.removeAll();

// Add compositions to the drop-down list.
for(i=1; i<=app.project.numItems; i++){
    if(app.project.item(i) instanceof CompItem){
        myPalette.grp.left.eight.layerNames.add('item',app.project.item(i).name);
        }
    }

// Add footage items to the drop-down list.
var itemIs = false;

    for(i=1; i<=app.project.numItems; i++){
        if(app.project.item(i) instanceof FootageItem && app.project.item(i).parentFolder.name != "Solids"){
            var footageItem = app.project.item(i).name;
            for(j=0; j<myPalette.grp.left.eight.layerNames.items.length; j++){
                if(myPalette.grp.left.eight.layerNames.items[j].toString() == footageItem){
                var itemIs = true;            
                } // if(myPalette.grp.left.eight.layerNames.items[j].toString() == footageItem;            
            } // for(j=0; j<myPalette.grp.left.eight.layerNames.items.length; j++){
            if(itemIs == false){
            myPalette.grp.left.eight.layerNames.add('item',footageItem);
            } //  if(itemIs == false){
        } // if(app.project.item(i) instanceof FootageItem && app.project.item(i).parentFolder.name != "Solids"){
    } //for(i=1; i<=app.project.numItems; i++){

myPalette.grp.left.eight.customLayerName.text = "";

} // function refreshLayers(palObject) {

//////////////////////////////////// Refresh layers end ////////////////////////////////////

//////////////////////////////////// Short functions start ////////////////////////////////////

function customLayerNameText (palObject) {

// Function is used to add the current name to the custom layer name text box.

var t = myPalette.grp.left.eight.layerNames.selection.toString();
myPalette.grp.left.eight.customLayerName.text = t;

} // function customLayerNameText (palObject) {

function automaticDisableGroups (){

// Function is used to disable groups when automatic render is chosen.
myPalette.grp.left.seven.enabled = false;
myPalette.grp.left.eight.enabled = false;

} // function automaticDisableGroups (){

function customDisableGroups (){

// Function is used to disable groups when custom render is chosen.
    
myPalette.grp.left.seven.enabled = true;
myPalette.grp.left.eight.enabled = false;
    
} // function customDisableGroups (){

function layerNameDisableGroups (){

// Function is used to disable groups when layer name render is chosen.
myPalette.grp.left.seven.enabled = false;
myPalette.grp.left.eight.enabled = true;

} // function layerNameDisableGroups (){

function frameRangeStatus (){

// Function is used to set the frame range status (enabled/disabled) when the work area checkbox is clicked.
    if(myPalette.grp.left.one.workArea.value == true){
        myPalette.grp.left.one.firstFrame.enabled = false;
        myPalette.grp.left.one.lastFrame.enabled = false;
            }else{
            myPalette.grp.left.one.firstFrame.enabled = true;
            myPalette.grp.left.one.lastFrame.enabled = true;
            }//else

} // function frameRangeStatus (){

function toggleInitials (){

// Function is used to enable/disable the initials text box.
if(myPalette.grp.left.five.useInitials.value == true){
    myPalette.grp.left.five.initials.enabled = true;
    myPalette.grp.left.five.initials.text = defaultInitials;    
        }else{
            myPalette.grp.left.five.initials.enabled = false;
            myPalette.grp.left.five.initials.text = "";
            }

} // function toggleInitials (){

//////////////////////////////////// Short functions end ////////////////////////////////////

//////////////////////////////////// Rush render function start ////////////////////////////////////

function rushRender (palObject) {
    
// Path of current AE project file. 
var projectPath = app.project.file.fsName.toString();

var itemInRQ = app.project.renderQueue.numItems;
var frameDur = app.project.activeItem.frameDuration
var dispStartFrame = app.project.displayStartFrame;

// Start end end of the frame range:
var startSecond = app.project.renderQueue.item(itemInRQ).timeSpanStart;
var endSecond = app.project.renderQueue.item(itemInRQ).timeSpanDuration;
var startFrame = startSecond/frameDur;
var durFrames = endSecond/frameDur;

var dispFrame = app.project.activeItem.displayStartTime/frameDur;
var startFrame = startSecond/frameDur;

// Frames to render
var firstFrame = (dispFrame + startFrame) + dispStartFrame;
var lastFrame = firstFrame + durFrames - 1;

// Make sure no rounding errors.
var firstRounding = parseInt(firstFrame)
var lastRounding = parseInt(lastFrame)
firstFrame = firstRounding;
lastFrame = lastRounding;

// Name of AE project file and remove .aep extension.
var aePF = app.project.file.name.replace(/%20/gi," ");
var aePFnoExt = aePF.substring(0,aePF.length-4);

// More variables.
var jobTitle = aePFnoExt;
var compName = app.project.activeItem.name;

// Rush commands.
var cmd      = "perl " + RV1 + " " +
                 "-field JobTitle: \""  + jobTitle + "\" " +
                 "-field Frames: "    + firstFrame  + "-" + lastFrame + " " +
                 "-field ScenePath: \""  + projectPath + "\" " +
                 "-field CompName: \""  + compName + "\" " +
                 "-field BatchClip: "  + RV2  + " " +
                 "-field BatchFrames: "  + RV3 + " " +
                 "-field AEVersion: "  + RV4  + " " +
                 "-field Cpus: \"" + RV5 + "\" " + " > /dev/null 2>&1 < /dev/null &";
                
var out = system.callSystem(cmd);

}//function networkRendering (palObject) {

//////////////////////////////////// Rush render function end ////////////////////////////////////

//////////////////////////////////// Help function start ////////////////////////////////////

function help (palObject) {
    
// Help text
alert("Auto Render v2.0 by Simon Björk.\r\r" +
"Written with a lot of help from the great people at AE Enhancers (www.aenhancers.com).\r\r" + 
"The script is a dockable panel in the After Effects UI. Install the script in the ScriptsUI folder and run it from the Window menu.\r\r" +
"Make sure you open the script in Adobe ExtendScript Toolkit (ships with After Effects) and edit the user variables. This is important in order for the script to work correctly in your pipeline.\r\r" +
"For questions/feature requests/bug reports contact me at bjork.simon@gmail.com.\r\r" +
"---------------------------------------\r\r" +
"- Frame range: Set the first and last frame of the frame range that you want to render.\r\r" +
"- Use work area: The script will render the frames within the work area of the selected composition. It will ignore whatever numbers written in the frame range boxes.\r\r" +
"- Render/Output settings: A list of your current output/render settings templates. If you create a new template you must click the refresh button in order to get it into the list.\r\r" +
" - Naming options: Choose between automatic naming (project file name), custom file name or a layer/composition name.\r\r" +
"- Render type: Choose between normal, pre render and proxy render.\r\r" +
"- Version up: The script saves a new version of the project file after a render is submitted.\r\r" +
"- Que only: Submitted renders will be placed in the render que.\r\r" + 
"- Use initials: Artist initials will be placed at the end of the file name.\r\r" +
"- Rush® Network Render: Submits the composition to Rush® Network Render (http://seriss.com/rush). Make sure you open the script and edit the Rush user variables.");

}//function networkRendering (palObject) {

//////////////////////////////////// Help function end ////////////////////////////////////
